/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.items.stacks.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.impactdev.impactor.api.items.AbstractedItemStack;
import net.impactdev.impactor.api.items.extensions.BookStack;
import net.impactdev.impactor.minecraft.items.stacks.builders.ImpactorBookStackBuilder;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.Nullable;

public class ImpactorBookStack
extends AbstractedItemStack
implements BookStack {
    private final BookStack.BookType bookType;
    private final String author;
    private final BookStack.Generation generation;
    private final TreeMap<Integer, Component> pages;

    public ImpactorBookStack(ImpactorBookStackBuilder builder) {
        super(builder.type.resolve(), builder);
        this.bookType = builder.type;
        this.author = builder.author;
        this.generation = builder.generation;
        this.pages = builder.pages;
    }

    @Override
    public BookStack.BookType bookType() {
        return this.bookType;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public BookStack.Generation generation() {
        return this.generation;
    }

    @Override
    public int pages() {
        return this.pages.size();
    }

    @Override
    public Component contentAt(int index) {
        return this.pages.get(index);
    }

    @Override
    public List<Component> contents() {
        return new ArrayList<Component>(this.pages.values());
    }

    @Override
    public CompoundBinaryTag nbt() {
        CompoundBinaryTag nbt = super.nbt();
        nbt = (CompoundBinaryTag)nbt.putString("author", this.author);
        nbt = (CompoundBinaryTag)nbt.putInt("generation", this.generation.ordinal());
        nbt = (CompoundBinaryTag)nbt.putString("title", "Impactor Generated Book");
        int max = this.pages.lastKey();
        ListBinaryTag pages = ListBinaryTag.empty();
        for (int i = 1; i <= max; ++i) {
            @Nullable Component result = this.pages.get(i);
            pages = (ListBinaryTag)pages.add((BinaryTag)StringBinaryTag.of((String)((String)GsonComponentSerializer.gson().serialize(Optional.ofNullable(result).orElse((Component)Component.empty())))));
        }
        return (CompoundBinaryTag)nbt.put("pages", (BinaryTag)pages);
    }
}

